-- Database: absensi_ma (lengkap)
CREATE DATABASE IF NOT EXISTS absensi_ma CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE absensi_ma;

-- users
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(100) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  role ENUM('admin','guru') NOT NULL,
  nama VARCHAR(200) NOT NULL,
  mapel VARCHAR(100) DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- mapel (referensi)
CREATE TABLE IF NOT EXISTS mapel (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama VARCHAR(100) NOT NULL UNIQUE
);

-- kelas
CREATE TABLE IF NOT EXISTS kelas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama VARCHAR(50) NOT NULL UNIQUE
);

-- siswa
CREATE TABLE IF NOT EXISTS siswa (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nis VARCHAR(30) NOT NULL UNIQUE,
  nama VARCHAR(200) NOT NULL,
  id_kelas INT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (id_kelas) REFERENCES kelas(id) ON DELETE CASCADE
);

-- tugas_guru (guru mengajar mapel di kelas tertentu)
CREATE TABLE IF NOT EXISTS tugas_guru (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_guru INT NOT NULL,
  id_kelas INT NOT NULL,
  id_mapel INT NOT NULL,
  keterangan VARCHAR(255),
  FOREIGN KEY (id_guru) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (id_kelas) REFERENCES kelas(id) ON DELETE CASCADE,
  FOREIGN KEY (id_mapel) REFERENCES mapel(id) ON DELETE CASCADE
);

-- absensi (per pertemuan)
CREATE TABLE IF NOT EXISTS absensi (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_siswa INT NOT NULL,
  id_guru INT NOT NULL,
  id_kelas INT NOT NULL,
  tanggal DATE NOT NULL,
  sesi VARCHAR(50) DEFAULT NULL,
  status ENUM('hadir','sakit','ijin','alpha') NOT NULL DEFAULT 'hadir',
  keterangan TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (id_siswa) REFERENCES siswa(id) ON DELETE CASCADE,
  FOREIGN KEY (id_guru) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (id_kelas) REFERENCES kelas(id) ON DELETE CASCADE
);

-- jurnal mengajar
CREATE TABLE IF NOT EXISTS jurnal (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_guru INT NOT NULL,
  id_kelas INT NOT NULL,
  id_mapel INT NOT NULL,
  tanggal DATE NOT NULL,
  sesi VARCHAR(50),
  kompetensi VARCHAR(255),
  materi TEXT,
  kegiatan TEXT,
  refleksi TEXT,
  file_lampiran VARCHAR(255) DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (id_guru) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (id_kelas) REFERENCES kelas(id) ON DELETE CASCADE,
  FOREIGN KEY (id_mapel) REFERENCES mapel(id) ON DELETE CASCADE
);

-- sample mapel
INSERT IGNORE INTO mapel (nama) VALUES
('Fiqih'),('Bahasa Arab'),('Matematika'),('Bahasa Inggris'),('Sejarah'),('Informatika');

-- sample kelas
INSERT IGNORE INTO kelas (nama) VALUES
('X-1'),('X-2'),('XI-1'),('XI-2'),('XII-1'),('XII-2');

-- sample siswa (5 per kelas)
INSERT IGNORE INTO siswa (nis, nama, id_kelas)
SELECT 'X1001','Ahmad Fauzi', (SELECT id FROM kelas WHERE nama='X-1') UNION ALL
SELECT 'X1002','Siti Aisyah', (SELECT id FROM kelas WHERE nama='X-1') UNION ALL
SELECT 'X1003','Budi Santoso', (SELECT id FROM kelas WHERE nama='X-1') UNION ALL
SELECT 'X1004','Lia Marlina', (SELECT id FROM kelas WHERE nama='X-1') UNION ALL
SELECT 'X1005','Rizky Putra', (SELECT id FROM kelas WHERE nama='X-1') UNION ALL

SELECT 'X2001','Fajar Hadi', (SELECT id FROM kelas WHERE nama='X-2') UNION ALL
SELECT 'X2002','Nina Kurnia', (SELECT id FROM kelas WHERE nama='X-2') UNION ALL
SELECT 'X2003','Dewi Lestari', (SELECT id FROM kelas WHERE nama='X-2') UNION ALL
SELECT 'X2004','Rian Pratama', (SELECT id FROM kelas WHERE nama='X-2') UNION ALL
SELECT 'X2005','Maya Indah', (SELECT id FROM kelas WHERE nama='X-2') UNION ALL

SELECT 'XI1001','Andi Wijaya', (SELECT id FROM kelas WHERE nama='XI-1') UNION ALL
SELECT 'XI1002','Rita Susanti', (SELECT id FROM kelas WHERE nama='XI-1') UNION ALL
SELECT 'XI1003','Teguh Haryanto', (SELECT id FROM kelas WHERE nama='XI-1') UNION ALL
SELECT 'XI1004','Yulia Sari', (SELECT id FROM kelas WHERE nama='XI-1') UNION ALL
SELECT 'XI1005','Zulfikar', (SELECT id FROM kelas WHERE nama='XI-1') UNION ALL

SELECT 'XI2001','Samsul Arif', (SELECT id FROM kelas WHERE nama='XI-2') UNION ALL
SELECT 'XI2002','Putri Melati', (SELECT id FROM kelas WHERE nama='XI-2') UNION ALL
SELECT 'XI2003','Gilang', (SELECT id FROM kelas WHERE nama='XI-2') UNION ALL
SELECT 'XI2004','Riska', (SELECT id FROM kelas WHERE nama='XI-2') UNION ALL
SELECT 'XI2005','Rendi', (SELECT id FROM kelas WHERE nama='XI-2') UNION ALL

SELECT 'XII1001','Diana', (SELECT id FROM kelas WHERE nama='XII-1') UNION ALL
SELECT 'XII1002','Eko', (SELECT id FROM kelas WHERE nama='XII-1') UNION ALL
SELECT 'XII1003','Fitri', (SELECT id FROM kelas WHERE nama='XII-1') UNION ALL
SELECT 'XII1004','Gita', (SELECT id FROM kelas WHERE nama='XII-1') UNION ALL
SELECT 'XII1005','Hendra', (SELECT id FROM kelas WHERE nama='XII-1') UNION ALL

SELECT 'XII2001','Irfan', (SELECT id FROM kelas WHERE nama='XII-2') UNION ALL
SELECT 'XII2002','Joko', (SELECT id FROM kelas WHERE nama='XII-2') UNION ALL
SELECT 'XII2003','Kiki', (SELECT id FROM kelas WHERE nama='XII-2') UNION ALL
SELECT 'XII2004','Luluk', (SELECT id FROM kelas WHERE nama='XII-2') UNION ALL
SELECT 'XII2005','Miftah', (SELECT id FROM kelas WHERE nama='XII-2');

-- sample users (admin + guru)
INSERT IGNORE INTO users (username, password, role, nama, mapel)
VALUES
('admin', '$2y$10$abcdefghijklmnopqrstuv', 'admin', 'Admin Madrasah', NULL);

-- Note: password hash placeholder above; please create users via create_users.php
