<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role('guru');
$me = current_user();
// kelas yang ditugaskan ke guru
$stmt = $pdo->prepare('SELECT k.* FROM kelas k JOIN tugas_guru t ON t.id_kelas=k.id WHERE t.id_guru=?');
$stmt->execute([$me['id']]);
$kelas_list = $stmt->fetchAll();

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])){
  $id_kelas = (int)$_POST['id_kelas'];
  $tanggal = $_POST['tanggal'];
  $sesi = trim($_POST['sesi'] ?? '');
  foreach($_POST['status'] as $id_siswa => $status){
    $keterangan = trim($_POST['keterangan'][$id_siswa] ?? '');
    // check existing
    $stmt = $pdo->prepare('SELECT id FROM absensi WHERE id_siswa=? AND tanggal=? AND sesi=?');
    $stmt->execute([$id_siswa,$tanggal,$sesi]);
    if($row = $stmt->fetch()){
      $pdo->prepare('UPDATE absensi SET status=?,keterangan=?,id_guru=?,id_kelas=? WHERE id=?')->execute([$status,$keterangan,$me['id'],$id_kelas,$row['id']]);
    } else {
      $pdo->prepare('INSERT INTO absensi (id_siswa,id_guru,id_kelas,tanggal,sesi,status,keterangan) VALUES (?,?,?,?,?,?,?)')->execute([$id_siswa,$me['id'],$id_kelas,$tanggal,$sesi,$status,$keterangan]);
    }
  }
  $msg = 'Absensi tersimpan.';
}

// load siswa saat kelas dipilih (AJAX not used; simple form submit)
$selected_kelas = (int)($_GET['id_kelas'] ?? 0);
$selected_date = $_GET['tanggal'] ?? date('Y-m-d');
$selected_sesi = $_GET['sesi'] ?? '1';
$siswa_list = [];
if($selected_kelas){
  $stmt = $pdo->prepare('SELECT * FROM siswa WHERE id_kelas=? ORDER BY nama');
  $stmt->execute([$selected_kelas]);
  $siswa_list = $stmt->fetchAll();
  // load existing absensi for date+sesi
  $stmt = $pdo->prepare('SELECT * FROM absensi WHERE id_kelas=? AND tanggal=? AND sesi=?');
  $stmt->execute([$selected_kelas,$selected_date,$selected_sesi]);
  $existing = [];
  foreach($stmt->fetchAll() as $r) $existing[$r['id_siswa']] = $r;
}
?>
<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
<title>Absensi</title><style>:root{--madrasah-green:#1e7e34}.navbar{background:var(--madrasah-green)}</style></head>
<body>
<nav class='navbar navbar-dark'><div class='container-fluid'><a class='navbar-brand'>Guru - Absensi</a><div class='d-flex'><a class='btn btn-outline-light btn-sm' href='/public/logout.php'>Logout</a></div></div></nav>
<div class='container py-4'><h5>Absensi Per Pertemuan</h5>
<?php if(!empty($msg)): ?><div class='alert alert-success'><?php echo htmlspecialchars($msg);?></div><?php endif; ?>
<form class='row g-2 mb-3' method='get'>
  <div class='col-md-4'><label>Kelas</label><select name='id_kelas' class='form-select' onchange='this.form.submit()'><option value=''>Pilih kelas</option><?php foreach($kelas_list as $k): ?><option value='<?php echo $k['id'];?>' <?php if($k['id']==$selected_kelas) echo 'selected';?>><?php echo htmlspecialchars($k['nama']);?></option><?php endforeach;?></select></div>
  <div class='col-md-3'><label>Tanggal</label><input type='date' name='tanggal' class='form-control' value='<?php echo $selected_date;?>' onchange='this.form.submit()'></div>
  <div class='col-md-2'><label>Sesi</label><input name='sesi' class='form-control' value='<?php echo htmlspecialchars($selected_sesi);?>'></div>
</form>

<?php if($selected_kelas): ?>
<form method='post'>
  <input type='hidden' name='id_kelas' value='<?php echo $selected_kelas;?>'>
  <input type='hidden' name='tanggal' value='<?php echo htmlspecialchars($selected_date);?>'>
  <input type='hidden' name='sesi' value='<?php echo htmlspecialchars($selected_sesi);?>'>
  <table class='table table-sm'><thead><tr><th>#</th><th>Nama</th><th>Status</th><th>Keterangan</th></tr></thead><tbody>
  <?php $i=1; foreach($siswa_list as $s): $st = $existing[$s['id']]['status'] ?? 'hadir'; $ket = $existing[$s['id']]['keterangan'] ?? ''; ?>
    <tr><td><?php echo $i++;?></td><td><?php echo htmlspecialchars($s['nama']);?></td>
    <td>
      <select name='status[<?php echo $s['id'];?>]' class='form-select form-select-sm'>
        <option value='hadir' <?php if($st=='hadir') echo 'selected';?>>Hadir</option>
        <option value='sakit' <?php if($st=='sakit') echo 'selected';?>>Sakit</option>
        <option value='ijin' <?php if($st=='ijin') echo 'selected';?>>Ijin</option>
        <option value='alpha' <?php if($st=='alpha') echo 'selected';?>>Alpha</option>
      </select>
    </td>
    <td><input name='keterangan[<?php echo $s['id'];?>]' class='form-control form-control-sm' value='<?php echo htmlspecialchars($ket);?>'></td></tr>
  <?php endforeach; ?>
  </tbody></table>
  <button name='save' class='btn btn-primary'>Simpan Absensi</button>
</form>
<?php else: ?>
  <div class='alert alert-info'>Pilih kelas terlebih dahulu sesuai tugas Anda.</div>
<?php endif; ?>
</div></body></html>
