<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role('guru');
$me = current_user();

// load tugas (mapel & kelas)
$stmt = $pdo->prepare('SELECT t.*, k.nama as kelas_n, m.nama as mapel_n FROM tugas_guru t JOIN kelas k ON k.id=t.id_kelas JOIN mapel m ON m.id=t.id_mapel WHERE t.id_guru=?');
$stmt->execute([$me['id']]);
$tugas = $stmt->fetchAll();

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])){
  $id_kelas = (int)$_POST['id_kelas'];
  $id_mapel = (int)$_POST['id_mapel'];
  $tanggal = $_POST['tanggal'];
  $sesi = trim($_POST['sesi'] ?? '');
  $kompetensi = trim($_POST['kompetensi'] ?? '');
  $materi = trim($_POST['materi'] ?? '');
  $kegiatan = trim($_POST['kegiatan'] ?? '');
  $refleksi = trim($_POST['refleksi'] ?? '');
  $stmt = $pdo->prepare('INSERT INTO jurnal (id_guru,id_kelas,id_mapel,tanggal,sesi,kompetensi,materi,kegiatan,refleksi) VALUES (?,?,?,?,?,?,?,?,?)');
  $stmt->execute([$me['id'],$id_kelas,$id_mapel,$tanggal,$sesi,$kompetensi,$materi,$kegiatan,$refleksi]);
  $msg = 'Jurnal tersimpan.';
}

$jurnal = $pdo->prepare('SELECT j.*, k.nama as kelas_n, m.nama as mapel_n FROM jurnal j JOIN kelas k ON k.id=j.id_kelas JOIN mapel m ON m.id=j.id_mapel WHERE j.id_guru=? ORDER BY j.tanggal DESC');
$jurnal->execute([$me['id']]);
$jurnal_list = $jurnal->fetchAll();
?>
<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
<title>Jurnal Mengajar</title><style>:root{--madrasah-green:#1e7e34}.navbar{background:var(--madrasah-green)}</style></head>
<body>
<nav class='navbar navbar-dark'><div class='container-fluid'><a class='navbar-brand'>Guru - Jurnal</a><div class='d-flex'><a class='btn btn-outline-light btn-sm' href='/public/logout.php'>Logout</a></div></div></nav>
<div class='container py-4'>
  <?php if(!empty($msg)): ?><div class='alert alert-success'><?php echo htmlspecialchars($msg);?></div><?php endif; ?>
  <div class='row'><div class='col-md-5'>
    <h5>Tambah Jurnal</h5>
    <form method='post'>
      <div class='mb-2'><label>Tugas (Mapel - Kelas)</label><select name='id_kelas' class='form-select mb-2' required>
        <?php foreach($tugas as $t): ?><option value='<?php echo $t['id_kelas'];?>' data-mapel='<?php echo $t['id_mapel'];?>'><?php echo htmlspecialchars($t['mapel_n'].' - '.$t['kelas_n']);?></option><?php endforeach;?>
      </select>
      <select name='id_mapel' class='form-select mb-2'><?php foreach($tugas as $t): ?><option value='<?php echo $t['id_mapel'];?>'><?php echo htmlspecialchars($t['mapel_n']);?></option><?php endforeach;?></select></div>
      <div class='mb-2'><label>Tanggal</label><input type='date' name='tanggal' class='form-control' value='<?php echo date('Y-m-d');?>' required></div>
      <div class='mb-2'><label>Sesi</label><input name='sesi' class='form-control'></div>
      <div class='mb-2'><label>Kompetensi</label><input name='kompetensi' class='form-control'></div>
      <div class='mb-2'><label>Materi</label><textarea name='materi' class='form-control'></textarea></div>
      <div class='mb-2'><label>Kegiatan</label><textarea name='kegiatan' class='form-control'></textarea></div>
      <div class='mb-2'><label>Refleksi</label><textarea name='refleksi' class='form-control'></textarea></div>
      <button name='save' class='btn btn-primary'>Simpan Jurnal</button>
    </form>
  </div>
  <div class='col-md-7'>
    <h5>Daftar Jurnal (Terakhir)</h5>
    <table class='table table-sm'><thead><tr><th>Tanggal</th><th>Mapel</th><th>Kelas</th><th>Materi</th></tr></thead><tbody>
    <?php foreach($jurnal_list as $j): ?><tr><td><?php echo $j['tanggal'];?></td><td><?php echo htmlspecialchars($j['mapel_n']);?></td><td><?php echo htmlspecialchars($j['kelas_n']);?></td><td><?php echo htmlspecialchars(substr($j['materi'],0,120));?></td></tr><?php endforeach;?>
    </tbody></table>
  </div></div>
</div>
</body></html>
