<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role('admin');
$guru = $pdo->query("SELECT id,nama FROM users WHERE role='guru'")->fetchAll();
$kelas = $pdo->query('SELECT * FROM kelas')->fetchAll();

$where = [];
$params = [];
if(!empty($_GET['id_guru'])){ $where[]='j.id_guru=?'; $params[]=(int)$_GET['id_guru']; }
if(!empty($_GET['id_kelas'])){ $where[]='j.id_kelas=?'; $params[]=(int)$_GET['id_kelas']; }
if(!empty($_GET['dari'])){ $where[]='j.tanggal>=?'; $params[]=$_GET['dari']; }
if(!empty($_GET['sampai'])){ $where[]='j.tanggal<=?'; $params[]=$_GET['sampai']; }

$sql = 'SELECT j.*, u.nama as guru_n, k.nama as kelas_n, m.nama as mapel_n FROM jurnal j JOIN users u ON u.id=j.id_guru JOIN kelas k ON k.id=j.id_kelas JOIN mapel m ON m.id=j.id_mapel';
if($where) $sql .= ' WHERE '.implode(' AND ',$where);
$sql .= ' ORDER BY j.tanggal DESC LIMIT 500';
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();
?>
<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
<title>Rekap Jurnal</title><style>:root{--madrasah-green:#1e7e34}.navbar{background:var(--madrasah-green)}</style></head>
<body>
<nav class='navbar navbar-dark'><div class='container-fluid'><a class='navbar-brand'>Admin - Rekap Jurnal</a><div class='d-flex'><a class='btn btn-outline-light btn-sm' href='/public/logout.php'>Logout</a></div></div></nav>
<div class='container py-4'>
  <form class='row g-2 mb-3' method='get'>
    <div class='col-md-3'><select name='id_guru' class='form-select'><option value=''>-- Semua Guru --</option><?php foreach($guru as $g): ?><option value='<?php echo $g['id'];?>' <?php if((int)($_GET['id_guru']??0)==$g['id']) echo 'selected';?>><?php echo htmlspecialchars($g['nama']);?></option><?php endforeach;?></select></div>
    <div class='col-md-3'><select name='id_kelas' class='form-select'><option value=''>-- Semua Kelas --</option><?php foreach($kelas as $k): ?><option value='<?php echo $k['id'];?>' <?php if((int)($_GET['id_kelas']??0)==$k['id']) echo 'selected';?>><?php echo htmlspecialchars($k['nama']);?></option><?php endforeach;?></select></div>
    <div class='col-md-2'><input type='date' name='dari' class='form-control' value='<?php echo htmlspecialchars($_GET['dari']??'');?>'></div>
    <div class='col-md-2'><input type='date' name='sampai' class='form-control' value='<?php echo htmlspecialchars($_GET['sampai']??'');?>'></div>
    <div class='col-md-2'><button class='btn btn-primary w-100'>Filter</button></div>
  </form>

  <table class='table table-sm'><thead><tr><th>Tanggal</th><th>Kelas</th><th>Mapel</th><th>Guru</th><th>Materi</th></tr></thead><tbody>
  <?php foreach($rows as $r): ?><tr><td><?php echo $r['tanggal'];?></td><td><?php echo htmlspecialchars($r['kelas_n']);?></td><td><?php echo htmlspecialchars($r['mapel_n']);?></td><td><?php echo htmlspecialchars($r['guru_n']);?></td><td><?php echo htmlspecialchars(substr($r['materi'],0,100));?></td></tr><?php endforeach;?>
  </tbody></table>
</div></body></html>
