<?php
require_once __DIR__ . '/../helpers/auth.php';
require_role('admin');
$kelas = $pdo->query('SELECT * FROM kelas')->fetchAll();
$guru = $pdo->query("SELECT id,nama,mapel FROM users WHERE role='guru'")->fetchAll();
$mapel = $pdo->query('SELECT * FROM mapel')->fetchAll();

if($_SERVER['REQUEST_METHOD'] === 'POST'){
  $id_guru = (int)($_POST['id_guru'] ?? 0);
  $id_kelas = (int)($_POST['id_kelas'] ?? 0);
  $id_mapel = (int)($_POST['id_mapel'] ?? 0);
  if($id_guru && $id_kelas && $id_mapel){
    $stmt = $pdo->prepare('INSERT INTO tugas_guru (id_guru,id_kelas,id_mapel,keterangan) VALUES (?,?,?,?)');
    $stmt->execute([$id_guru,$id_kelas,$id_mapel, '']);
    header('Location: tugas_guru.php'); exit;
  }
}
$tugas = $pdo->query('SELECT t.*, u.nama as guru_n, k.nama as kelas_n, m.nama as mapel_n FROM tugas_guru t JOIN users u ON u.id=t.id_guru JOIN kelas k ON k.id=t.id_kelas JOIN mapel m ON m.id=t.id_mapel ORDER BY t.id')->fetchAll();
?>
<!doctype html><html><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css' rel='stylesheet'>
<title>Pembagian Tugas</title><style>:root{--madrasah-green:#1e7e34}.navbar{background:var(--madrasah-green)}</style></head>
<body>
<nav class='navbar navbar-dark'><div class='container-fluid'><a class='navbar-brand'>Admin - Pembagian Tugas</a><div class='d-flex'><a class='btn btn-outline-light btn-sm' href='/public/logout.php'>Logout</a></div></div></nav>
<div class='container py-4'><div class='row'><div class='col-md-4'><h5>Tambah Tugas Guru</h5>
<form method='post'>
  <div class='mb-2'><label>Guru</label><select name='id_guru' class='form-select'><?php foreach($guru as $g): ?><option value='<?php echo $g['id'];?>'><?php echo htmlspecialchars($g['nama'].' - '.$g['mapel']);?></option><?php endforeach;?></select></div>
  <div class='mb-2'><label>Kelas</label><select name='id_kelas' class='form-select'><?php foreach($kelas as $k): ?><option value='<?php echo $k['id'];?>'><?php echo htmlspecialchars($k['nama']);?></option><?php endforeach;?></select></div>
  <div class='mb-2'><label>Mapel</label><select name='id_mapel' class='form-select'><?php foreach($mapel as $m): ?><option value='<?php echo $m['id'];?>'><?php echo htmlspecialchars($m['nama']);?></option><?php endforeach;?></select></div>
  <button class='btn btn-success w-100'>Simpan</button>
</form></div>
<div class='col-md-8'><h5>Daftar Tugas</h5><table class='table'><thead><tr><th>Guru</th><th>Mapel</th><th>Kelas</th></tr></thead><tbody><?php foreach($tugas as $t): ?><tr><td><?php echo htmlspecialchars($t['guru_n']);?></td><td><?php echo htmlspecialchars($t['mapel_n']);?></td><td><?php echo htmlspecialchars($t['kelas_n']);?></td></tr><?php endforeach;?></tbody></table></div></div></div>
</body></html>
