<?php
require_once __DIR__ . '/config.php';

// Buat akun admin & guru dengan password_hash
$users = [
  ['username'=>'admin','password'=>'admin123','role'=>'admin','nama'=>'Admin Madrasah','mapel'=>null],
  ['username'=>'guru_fiqih','password'=>'guru123','role'=>'guru','nama'=>'Ust. Ahmad','mapel'=>'Fiqih'],
  ['username'=>'guru_arab','password'=>'guru123','role'=>'guru','nama'=>'Ustadzah Siti','mapel'=>'Bahasa Arab'],
  ['username'=>'guru_mtk','password'=>'guru123','role'=>'guru','nama'=>'Pak Anton','mapel'=>'Matematika'],
  ['username'=>'guru_bing','password'=>'guru123','role'=>'guru','nama'=>'Ibu Rina','mapel'=>'Bahasa Inggris'],
  ['username'=>'guru_info','password'=>'guru123','role'=>'guru','nama'=>'Pak Joko','mapel'=>'Informatika']
];

foreach($users as $u){
  $stmt = $pdo->prepare('SELECT id FROM users WHERE username = ?');
  $stmt->execute([$u['username']]);
  if($stmt->fetch()){
    echo "User {$u['username']} sudah ada.<br>";
    continue;
  }
  $pw = password_hash($u['password'], PASSWORD_DEFAULT);
  $stmt = $pdo->prepare('INSERT INTO users (username, password, role, nama, mapel) VALUES (?,?,?,?,?)');
  $stmt->execute([$u['username'], $pw, $u['role'], $u['nama'], $u['mapel']]);
  echo "User {$u['username']} dibuat.<br>";
}

// assign some tugas_guru automatically: each guru to one class for demo
$guru_ids = $pdo->query("SELECT id, mapel FROM users WHERE role='guru'")->fetchAll();
$kelas = $pdo->query("SELECT id FROM kelas ORDER BY id")->fetchAll();

$kidx = 0;
foreach($guru_ids as $g){
  $kid = $kelas[$kidx % count($kelas)]['id'];
  // find mapel id
  $stmt = $pdo->prepare('SELECT id FROM mapel WHERE nama = ?');
  $stmt->execute([$g['mapel']]);
  $mapel = $stmt->fetchColumn() ?: 1;
  // insert tugas if not exist
  $stmt = $pdo->prepare('SELECT id FROM tugas_guru WHERE id_guru=? AND id_kelas=? AND id_mapel=?');
  $stmt->execute([$g['id'],$kid,$mapel]);
  if(!$stmt->fetch()){
    $stmt = $pdo->prepare('INSERT INTO tugas_guru (id_guru,id_kelas,id_mapel,keterangan) VALUES (?,?,?,?)');
    $stmt->execute([$g['id'],$kid,$mapel,'Tugas mengajar contoh']);
    echo "Tugas guru {$g['id']} -> kelas {$kid} dibuat.<br>";
  }
  $kidx++;
}

echo '<hr> Selesai. Hapus file create_users.php dari server demi keamanan.';
