<?php
require_once __DIR__ . '/../config.php';

function is_logged_in() {
  return !empty($_SESSION['user_id']);
}
function current_user() {
  global $pdo;
  if(!is_logged_in()) return null;
  static $user = null;
  if($user) return $user;
  $stmt = $pdo->prepare('SELECT id, username, nama, role, mapel FROM users WHERE id = ?');
  $stmt->execute([$_SESSION['user_id']]);
  $user = $stmt->fetch();
  return $user;
}
function require_role($role) {
  if(!is_logged_in()) { header('Location: /public/login.php'); exit; }
  $u = current_user();
  if($u['role'] !== $role) { echo "Akses ditolak"; exit; }
}
