<?php
require_once __DIR__ . '/../config.php';
$err = '';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
  $username = $_POST['username'] ?? '';
  $password = $_POST['password'] ?? '';
  $stmt = $pdo->prepare('SELECT * FROM users WHERE username = ?');
  $stmt->execute([$username]);
  $u = $stmt->fetch();
  if($u && password_verify($password, $u['password'])){
    $_SESSION['user_id'] = $u['id'];
    if($u['role'] === 'admin') header('Location: /admin/dashboard.php');
    else header('Location: /guru/dashboard.php');
    exit;
  } else {
    $err = 'Login gagal: username atau password salah';
  }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <title>Login - Absensi MA Bahrul Ulum</title>
  <style>
    :root{--madrasah-green:#1e7e34;}
    .btn-primary{background:var(--madrasah-green);border-color:var(--madrasah-green)}
    .navbar{background:var(--madrasah-green)}
  </style>
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-11 col-sm-8 col-md-5">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="card-title mb-3">Login Sistem Absensi</h4>
          <?php if($err): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($err); ?></div>
          <?php endif; ?>
          <form method="post">
            <div class="mb-2">
              <label class="form-label">Username</label>
              <input name="username" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">Password</label>
              <input name="password" type="password" class="form-control" required>
            </div>
            <button class="btn btn-primary w-100">Masuk</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
